%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% funtion to report best pareto trace designs

function [designList,NPT] = bestParetoTraceFinder(FPV,fuzzy)
% Inputs
%   FPV - (design,epoch) matrix of fuzzy pareto values
%           NOTE: can also use effectiveFPV after defining a strategy
%   fuzzy - scalar, allowed fuzzy %
% Outputs
%   designList - vector of design numbers with highest NPT
%   NPT - scalar, the normalized pareto trace of the designs in designList

numEpochs = size(FPV,2);

inSet = FPV<=fuzzy;
NPTvector = sum(inSet,2)./numEpochs;
[sortedNPT index] = sort(NPTvector);  % this sorts ascending, so we want the end

% output 1
NPT = sortedNPT(end);
%

findAll = sortedNPT==NPT;

% output 2
designList = index(findAll);
%

end